//: [Vorherige Seite](@previous)
import UIKit
import PlaygroundSupport
//: ## Animation mit UIViewPropertyAnimator
//: ## – Zwischenstop & Kursänderung
//:
//Demo-View erstellen, Button verschieben und Live-View
let container = demoView(frame: CGRect(x: 0, y: 0,
                                       width: 400, height: 600))
let frame = container.frame
container.demoButton.center = CGPoint(x:frame.midX,
                                      y: frame.midY)
PlaygroundPage.current.liveView = container
//: Um die Animation während der Ausführung zu ändern, muss sie zunächst einmal angehalten werden und der Animator muss im aktiven oder inaktiven Zustand sein. Im Pause-Modus bleiben die bisherigen Aufträge an den Animator erhalten. Fügt man weitere Befehle hinzu, ergänzen Sie die alten, statt sie zu überschreiben. Folgender Code lässt den Button beispielsweise ab dem zweiten Knopfdruck nach unten wandern. Statt dadurch aber senkrecht nach unten zu fallen, kombiniert iOS die zuvor spezifizierte Bewegung nach Rechts mit der Bewegung nach unten – der Button fällt auf einer Parabel-ähnlichen Kurve nach unten.
public class actionHandler: NSObject {
    
    private var animator = UIViewPropertyAnimator(duration: 2.0, curve: .easeInOut) {
        container.demoButton.center.x = frame.maxX - container.demoButton.frame.size.width
    }

    public func animate() {
        if animator.isRunning {
            animator.pauseAnimation()
            animator.addAnimations {
                container.demoButton.center.y = frame.maxY - container.demoButton.frame.size.height
            }
            animator.startAnimation()
        } else {
            animator.startAnimation()
        }
    }
}
//: Anschließend können Sie die Action wie gewohnt an den Button anhängen
let responder = actionHandler()
container.demoButton.addTarget(responder,
                               action: #selector(actionHandler.animate),
                               for: .touchDown)

//: [Nächste Seite](@next)
